unit APIText;

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//             The Delphi Component for Text Creating by WinAPI               //
//                                                                            //
//                              Name: TAPIText                                //
//                               Version: 1.00                                //
//                        Author: Andrey G. Sadovoy                           //
//                                dec. 2005                                   //
//                                                                            //
//                       e-mail: sadovoya@mtu-net.ru                          //
//                       http://SintResEng.narod.ru                           //
//                                                                            //
//   All rights reserved 2005                                                 //
////////////////////////////////////////////////////////////////////////////////

interface

uses
  Windows, Messages, SysUtils, Classes, Controls,
  Graphics; //for rich dialog selection of colour etc.

type
  TFontWeight = (Thin, ExtraLight, Light, Normal,
                          Medium, SemiBold, Bold,
                          ExtraBold, Heavy);
  TAPIText = class(TGraphicControl)
  private
    { Private declarations }
  FTextXPos: Word; // x-position of text in component
  FTextYPos: Word; // y-position of text in component
  FTransp: Boolean; // background's transparent (true, false)
  FColor: TColor;   // background color
  FText: String; // user's text
  FFontName: TFontName;  // name of font
  FFontColor: TColor; // font colour
  FFontHeight: Integer;  // font height
  FFontWidth: Integer;   // font width
  FFontWeight: TFontWeight;  // font weight (heavy etc.)
  FUnderline: Boolean; // underline (true, false)
  FEscapement: Integer; // angle of text to horisontal direction in 0,1 deg.
  FItalic: Boolean; // italic font (true, false)
  FStrikeOut: Boolean; // strike out (true, false)
  FShadowX: Word; // distance from shadow to text by x
  FShadowY:Word;  // distance from shadow to text by y
  FShadowColor: TColor;  // shadow color
  procedure SetTextXPos(AValue: Word);
  procedure SetTextYPos(AValue: Word);
  procedure SetTransp(AValue: Boolean);
  procedure SetColor(AValue: TColor);
  procedure SetText(AValue: String);
  procedure SetFontName(AValue: TFontName);
  procedure SetFontColor(AValue: TColor);
  procedure SetFontHeight(AValue: Integer);
  procedure SetFontWidth(AValue: Integer);
  procedure SetFontWeight(AValue: TFontWeight);
  procedure SetUnderline(AValue: Boolean);
  procedure SetEscapement(AValue: Integer);
  procedure SetItalic(AValue: Boolean);
  procedure SetStrikeOut(AValue: Boolean);
  procedure SetShadowX(AValue: Word);
  procedure SetShadowY(AValue: Word);
  procedure SetShadowColor(AValue: TColor);

  protected

    { Protected declarations }

  public

    { Public declarations }

  constructor Create(AOwner:TComponent); override;
  procedure Paint; override; // let's draw
  published
    { Published declarations }
  property Left;
  property Top;
  property Height; 
  property Width;

  // we add ours :
  property FontName: TFontName
  read FFontName
  write SetFontName;
  
  property TextXPos: Word
  read FTextXPos
  write SetTextXPos;

  property TextYPos: Word
  read FTextYPos
  write SetTextYPos;

  property Transp: boolean
  read FTransp
  write SetTransp;

  property Color: TColor
  read FColor
  write SetColor;

  property Text: String
  read FText
  write SetText;

  property FontColor: TColor
  read FFontColor
  write SetFontColor;

  property FontHeight: Integer
  read FFontHeight
  write SetFontHeight;

  property FontWidth: Integer
  read FFontWidth
  write SetFontWidth;

  property FontWeight: TFontWeight
  read FFontWeight
  write SetFontWeight;

  property Underline: Boolean
  read FUnderline
  write SetUnderline;

  property Escapement: Integer
  read FEscapement
  write SetEscapement;

  property Italic: Boolean
  read FItalic
  write SetItalic;

  property StrikeOut: Boolean
  read FStrikeOut
  write SetStrikeOut;

  property ShadowX: Word
  read FShadowX
  write SetShadowX;

  property ShadowY: Word
  read FShadowY
  write SetShadowY;

  property ShadowColor: TColor
  read FShadowColor
  write SetShadowColor;

end;

procedure Register;

implementation

procedure Register;
begin
RegisterComponents('Andrey G. Sadovoy', [TAPIText]);
end;

Constructor TAPIText.Create(AOwner:TComponent);
begin
Inherited Create(AOwner);
///////////////////////////
FTextXPos:=0;
FTextYPos:=0;
FTransp:=False;
FStrikeOut:=False;
FFontName:='Arial';
Height:=24;
Width:=87;
FFontHeight:=24;
FFontWidth:=0;
FFontWeight:=Heavy;
FUnderline:=True;
FItalic:=True;
FShadowX:=2;
FShadowY:=2;
FShadowColor:=clBlack;
FColor:=clBlue;
FFontColor:=clRed;
FText:='API Text';
////////////////////////////
repaint; 
end;

procedure TAPIText.SetTextXPos(AValue: Word);
begin
FTextXPos:=AValue;
repaint;
end;

procedure TAPIText.SetTextYPos(AValue: Word);
begin
FTextYPos:=AValue;
repaint;
end;

procedure TAPIText.SetTransp(AValue: Boolean);
begin
FTransp:=AValue;
repaint;
end;

procedure TAPIText.SetColor(AValue: TColor);
begin
FColor:=AValue;
repaint;
end;

procedure TAPIText.SetText(AValue: String);
begin
FText:=AValue;
repaint;
end;

procedure TAPIText.SetFontName(AValue: TFontName);
begin
FFontName:=AValue;
repaint;
end;

procedure TAPIText.SetFontColor(AValue: TColor);
begin
FFontColor:=AValue;
repaint;
end;

procedure TAPIText.SetFontHeight(AValue: Integer);
begin
FFontHeight:=AValue;
repaint;
end;

procedure TAPIText.SetFontWidth(AValue: Integer);
begin
FFontWidth:=AValue;
repaint;
end;

procedure TAPIText.SetFontWeight(AValue: TFontWeight);
begin
FFontWeight:=AValue;
repaint;
end;

procedure TAPIText.SetUnderline(AValue: Boolean);
begin
FUnderline:=AValue;
repaint;
end;

procedure TAPIText.SetEscapement(AValue: Integer);
begin
FEscapement:=AValue;
repaint;
end;

procedure TAPIText.SetItalic(AValue: Boolean);
begin
FItalic:=AValue;
repaint;
end;

procedure TAPIText.SetStrikeOut(AValue: Boolean);
begin
FStrikeOut:=AValue;
repaint;
end;

procedure TAPIText.SetShadowX(AValue: Word);
begin
FShadowX:=AValue;
repaint;
end;

procedure TAPIText.SetShadowY(AValue: Word);
begin
FShadowY:=AValue;
repaint;
end;

procedure TAPIText.SetShadowColor(AValue: TColor);
begin
FShadowColor:=AValue;
repaint;
end;

procedure TAPIText.Paint;
var
  LF: TLogFont;
  Fnt: HFont;
begin
Canvas.Brush.Color:=FColor;
FillChar(LF, SizeOf(LF), 0);
with LF do
begin
  lfHeight:=FFontHeight;
  lfWidth:=FFontWidth;
  Case FFontWeight of
    Thin: lfWeight:= 100;
    ExtraLight: lfWeight:=20;
    Light: lfWeight:=300;
    Normal: lfWeight:=400;
    Medium: lfWeight:=500;
    SemiBold: lfWeight:=600;
    Bold: lfWeight:=700;
    ExtraBold: lfWeight:=800;
    Heavy: lfWeight:=900;
  end;
  If FItalic then
  lfItalic:=1 else lfItalic:=0;
  if FUnderline then
  lfUnderline :=1 else lfUnderline :=0;
  if FStrikeOut then lfStrikeOut:=1
  else lfStrikeOut:=0;
  lfEscapement := FEscapement;
  lfQuality:=Proof_Quality;
  StrPCopy(lfFaceName, FFontName);
end;
with Canvas do
begin
  Fnt := CreateFontIndirect(LF) ;
  Font.Handle := Fnt;
  // shadow of text in background
  Font.Color:=FShadowColor;
  if FTransp then
  SetBKMode(Handle,Transparent)
  else SetBKMode(Handle,Opaque);
  TextOut(FTextXPos+FShadowX, FTextYPos+FShadowY, FText);
  // text
  SetBKMode(Handle,Transparent);
  Canvas.Font.Color:=FFontColor;
  TextOut(FTextXPos,FTextYPos, FText);
  DeleteObject(Fnt);
end;
end;

end.

